<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;

class UserPinController extends Controller
{
    public function showForm()
    {
        $user = auth()->user();

        if (empty($user->withdraw_pin)) {
            $pageTitle = 'Set Your 4-Digit PIN';
            return view('Template::user.set_pin', compact('pageTitle'));
        }

        $pageTitle = 'Verify Your PIN';
        return view('Template::user.verify_pin', compact('pageTitle'));
    }

    public function verify(Request $request)
    {
        $request->validate([
            'pin' => 'required|digits:4',
        ]);

        $user = auth()->user();

        if ($user->withdraw_pin === $request->pin) {
            session(['pin_verified' => true]);
            return redirect()->route('user.home');
        }

        $notify[] = ['error', 'Incorrect PIN'];
        return back()->withNotify($notify);
    }
    
    public function storePin(Request $request)
    {
        $request->validate([
            'pin' => 'required|confirmed|digits:4',
    ]);

    $user = auth()->user();
    $user->withdraw_pin = $request->pin;
    $user->save();

    session()->put('pin_verified', true);

    return redirect()->route('user.home')->with('success', 'PIN set successfully.');
    }

    public function setPin(Request $request)
    {
        $request->validate([
            'pin' => 'required|digits:4|confirmed',
        ]);

        $user = auth()->user();
        $user->withdraw_pin = $request->pin;
        $user->save();

        session(['pin_verified' => true]);

        $notify[] = ['success', 'PIN set successfully'];
        return redirect()->route('user.home')->withNotify($notify);
    }

    public function showResetForm()
    {
    $pageTitle = 'Reset PIN';
    return view('Template::user.pin_reset_request', compact('pageTitle'));
    }

    public function sendResetOtp(Request $request)
    {
    $user = auth()->user();
    $otp = rand(100000, 999999);

    session(['pin_reset_otp' => $otp, 'pin_reset_email' => $user->email]);

    // You can use Laravel notifications or Mail
    Mail::raw("Your PIN reset OTP is: $otp", function ($message) use ($user) {
        $message->to($user->email)
            ->subject('PIN Reset OTP');
    });

    return redirect()->route('user.pin.otp.form')->with('success', 'OTP sent to your email.');
}

    public function showOtpForm()
    {
    $pageTitle = 'Enter OTP & New PIN';
    return view('Template::user.pin_reset_otp', compact('pageTitle'));
    }

    public function resetPinWithOtp(Request $request)
    {
    $request->validate([
        'otp' => 'required|digits:6',
        'pin' => 'required|confirmed|digits:4',
    ]);

    if ($request->otp != session('pin_reset_otp')) {
        return back()->withErrors(['otp' => 'Invalid OTP']);
    }

    $user = auth()->user();
    $user->withdraw_pin = $request->pin;
    $user->save();

    session()->forget(['pin_reset_otp', 'pin_reset_email']);
    session(['pin_verified' => true]);

    return redirect()->route('user.home')->with('success', 'PIN reset successfully.');
    }
}