<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\VirtualCard;
use Illuminate\Http\Request;

class VirtualCardController extends Controller
{
    public function pending()
    {
        $pageTitle = 'Pending Virtual Cards';
        $cards = VirtualCard::where('status', 0)->with('user')->latest()->paginate(20);
        return view('admin.virtual_cards.pending', compact('pageTitle', 'cards'));
    }

    public function approved()
    {
        $pageTitle = 'Approved Virtual Cards';
        $cards = VirtualCard::where('status', 1)->with('user')->latest()->paginate(20);
        return view('admin.virtual_cards.approved', compact('pageTitle', 'cards'));
    }

    public function approve($id)
    {
        $card = VirtualCard::findOrFail($id);
        $card->status = 1;
        $card->save();

        $notify[] = ['success', 'Virtual Card Approved Successfully'];
        return back()->withNotify($notify);
    }
}