use App\Notifications\VirtualCardApproved; // Add at top
use Illuminate\Support\Facades\Notification;
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\VirtualCard;
use Illuminate\Http\Request;

class ManageVirtualCardController extends Controller
{
    public function pending()
    {
    $pageTitle = 'Pending Virtual Cards';
    $cards = VirtualCard::where('status', 0)->with('user')->latest()->paginate(10);
    return view('admin.virtual_cards.pending', compact('pageTitle', 'cards'));
    }

    public function approve($id)
    {
    $card = VirtualCard::findOrFail($id);
    $card->status = 1;
    $card->save();

    // Send notification to user
    Notification::route('mail', $card->user->email)
        ->notify(new VirtualCardApproved($card));

    $notify[] = ['success', 'Virtual card approved and user notified'];
    return back()->withNotify($notify);
    }

